/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package college;

import java.util.GregorianCalendar;

/**
 *
 * @author Daryle Niedermayer, I.S.P., PMP
 * @version 1.0 2008/05/05
 */
public class Student extends Person {
    
    private String studentID;
    private String faculty;
    private String program;
    private int yearEnrolled;
    private float GPA;
    private int creditHoursEarned;
    private boolean isActive;
    
    public Student(String studentID, String faculty, String program) {
        this.studentID = studentID;
        this.faculty = faculty;
        this.program = program;
        isActive = true;
        creditHoursEarned = 0;
        GPA = 0;
        yearEnrolled = new GregorianCalendar().get(GregorianCalendar.YEAR);
    }

    public Student(String studentID, String faculty) {
    this.studentID = studentID;
        this.faculty = faculty;
        isActive = true;
        creditHoursEarned = 0;
        GPA = 0;
        yearEnrolled = new GregorianCalendar().get(GregorianCalendar.YEAR);
    }
    public Student(String studentID) {
    this.studentID = studentID;
        isActive = true;
        creditHoursEarned = 0;
        GPA = 0;
        yearEnrolled = new GregorianCalendar().get(GregorianCalendar.YEAR);
    }
    
    public float getGPA() {
        return this.GPA;
    }
    
    public String getFaculty() {
        return faculty;
    }
    
    public void setFaculty(String faculty) {
        this.faculty = faculty;
    }
    
    public String getProgram() {
        return program;
    }
    
    public void setProgram(String program) {
        this.program = program;
    }
    
    public boolean getActive() {
        return isActive;
    }
    
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
    
    public void setYearEnrolled(int yearEnrolled) {
        this.yearEnrolled = yearEnrolled;
    }
    
    public int getYearEnrolled() {
        return yearEnrolled;
    }
    /**
     * Returns the calendar age of the person from today.
     * THIS IS ASSIGNMENT 1, PART 2
     * @return
     */
    @Override
    public Double getAge() {
        return new Double((new GregorianCalendar().get(GregorianCalendar.YEAR))-this.yearEnrolled);
    }
   
}
    
    